%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Code for replication of results in the paper:
%%%%  Denotative and Connotative Control of Uncertainty: A Computational Dual Process Model
%%%%  Authors: Jesse Hoey (University of Waterloo),  
%%%%           Neil MacKinnon (University of Guelph),
%%%%           Tobias Schroeder  (Potdsam University of Applied Sciences)
%%%%  Copyright: the authors, 2021
%%%%  For research purposes only.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This file:  main script to generate Figure 6 (cognitive dissonance)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% the EPA value and covariance matrices for the identity 'child' from the USA 2015 survey
%% all datasets available by following links from bayesact.ca or at
%% http://affectcontroltheory.org/resources-for-researchers/data-sets-for-simulation/
childepa=[1.9721,-1.1668,1.9887];
childcov=[1.5398,0.0046,-0.2536;0.0046,2.2291,-0.7024;-0.2536,-0.7024,2.6669];
%%% marginal variances
childvar=[1.5108,2.1870,2.6166];

%% from Shank and Lulham 2016 Products as Affective Modifiers of Identities
iphoneepa=[1.36,1.62,1.48];
blackberryepa=[-0.67,-0.71,-0.28];
%% standard deviations
iphonesd=[1.94,1.52,1.34];
blackberrysd=[1.79,1.63,1.83];

%% flag to print all to PDFs if needed
%% if output_file_ext is 'none' we don't print out
output_file_ext='eps'  % can be 'none','eps','jpg','png','pdf'...
print_flag=output_file_ext;
print_to_file=not(strcmp(print_flag,'none'))
if output_file_ext=='eps'
  print_flag='epsc';  %% for color
end

dim_to_use = 1
dim_labels={'evaluation';'power';'activity'};

%% flag to use actual covariance values for figure 2 and 4
%% SET TO FALSE to get the exact figures shown in the paper
use_real_cov=false;

%% mean of the prior on y,
uyorig=childepa(dim_to_use); 
uy=uyorig;  
%% variance of the prior on y (is the square of this) - this is standard deviation
sigyorig=sqrt(childvar(dim_to_use));  
sigy=sigyorig;

%% a set of different variances to look at the change over them
sigys=[0.5,0.75,round(sqrt(childvar(dim_to_use)),2),1.7,2.0];
%% variance in the somatic transform (is the square of this) - this is std. deviation
gamma=[0.3,0.3];
%% use this version to generate figures using the actual variances from the USA 2015 dataset:
if use_real_cov
  gamma=[sqrt(blackberrysd(dim_to_use)),sqrt(iphonesd(dim_to_use))];
end

%% evaluation values of iphone and blackberry
iphonee=iphoneepa(dim_to_use);
blackberrye=blackberryepa(dim_to_use);
xdist=[blackberrye,iphonee];

%% prob the person device obtained is bad (at the blackberry level)
%% forced choice paradigm
px=0.8; 
pxp = [px,1-px];
pxs=[px];

priorys=[];
pprimeys=[];
pprimexs=[];


y=[-4.95:0.05:5];   

for sigy=sigys
  [priory,pprimey,pprimex]=computePost(uy,sigy,pxp,xdist,gamma,y);
  priorys=[priorys;priory];
  pprimeys=[pprimeys;pprimey];
  pprimexs=[pprimexs;pprimex];
end



nuys=size(priorys,1);

%% now plot as a function of y for different values of the prior over x, ux
%%% this is Figure 6(a)
figure(1);
clf;
hold off;
plot(repmat(y,nuys,1)',pprimeys','LineWidth',2);
hold on;
xent=-pxs.*log2(pxs)-(1-pxs).*log2(1-pxs);
legendvals=num2cell(string(sigys));
legend(repmat(["\sigma_y= "],size(sigys,2),1)+legendvals'+repmat(["     S(P')="],nuys,1)+num2str(sum(-pprimexs.*log2(pprimexs),2),'%1.2f')+repmat(["      P'(bad)="],nuys,1)+num2str(pprimexs(:,1),2),'AutoUpdate','off','Location','northwest');
set(gca,'ColorOrderIndex',1);
plot(repmat(y,nuys,1)',priorys','--','LineWidth',2);
set(gca,'FontWeight', 'bold');
ylabel('P(Y)','FontSize',12,'FontWeight','bold');
xlabel(['Y=',dim_labels{dim_to_use}],'FontSize',12,'FontWeight','bold');


title('Figure 6a');

if print_to_file
  print(['figure6a.',output_file_ext],['-d',print_flag]);
end


%% now plot the trends 
figure(2);
hold off;
clf;
%reverse everything
pprimexsr=1-pprimexs;
sigysr=1./(sigys.*sigys);
yyaxis left;
plot(sigysr,sum(-pprimexsr.*log2(pprimexsr),2),'b-o','LineWidth',3);
hold on;
yyaxis right;
plot(sigysr,pprimexsr(:,1),'r-*','LineWidth',3);
legend(["entropy of posterior in x";"P'(good) (posterior belief item is good)"],'Location','northeast');
set(gca,'FontWeight', 'bold');
yyaxis right;
ylabel('Probability (item is good)','FontSize',16,'FontWeight','bold','Color','r');
yyaxis left;
ylabel('Entropy','FontSize',16,'FontWeight','bold','Color','b');
xlabel(['\sigma_y^{-2} (certainty in ',dim_labels{dim_to_use},' of this person)'],'FontSize',12,'FontWeight','bold');

title('Figure 6b');

if print_to_file
  print(['figure6b.',output_file_ext],['-d',print_flag]);
end


%% prob the person device obtained is bad (at the blackberry level)
%% this is the free choice paradigm
px=0.5; 
pxp = [px,1-px];
pxs=[px];
y=[-4.95:0.05:5];   
priorys=[];
pprimeys=[];
pprimexs=[];
for sigy=sigys
  [priory,pprimey,pprimex]=computePost(uy,sigy,pxp,xdist,gamma,y);
  priorys=[priorys;priory];
  pprimeys=[pprimeys;pprimey];
  pprimexs=[pprimexs;pprimex];
end


nuys=size(priorys,1);

%% now plot as a function of y for different values of the prior over x, ux
%%% this is Figure 6(a)
figure(3);
clf;
hold off;
plot(repmat(y,nuys,1)',pprimeys','LineWidth',2);
hold on;
xent=-pxs.*log2(pxs)-(1-pxs).*log2(1-pxs);
legendvals=num2cell(string(sigys));
legend(repmat(["\sigma_y= "],size(sigys,2),1)+legendvals'+repmat(["     S(P')="],nuys,1)+num2str(sum(-pprimexs.*log2(pprimexs),2),'%1.2f')+repmat(["      P'(bad)="],nuys,1)+num2str(pprimexs(:,1),2),'AutoUpdate','off','Location','northwest');
set(gca,'ColorOrderIndex',1);
plot(repmat(y,nuys,1)',priorys','--','LineWidth',2);
set(gca,'FontWeight', 'bold');
ylabel('P(Y)','FontSize',12,'FontWeight','bold');
xlabel(['Y=',dim_labels{dim_to_use}],'FontSize',12,'FontWeight','bold');

title('Figure 6c');

if print_to_file
  print(['figure6c.',output_file_ext],['-d',print_flag]);
end






%% now plot the trends 
figure(4);
hold off;
clf;
%reverse everything
pprimexsr=1-pprimexs;
sigysr=1./(sigys.*sigys);
yyaxis left;
plot(sigysr,sum(-pprimexsr.*log2(pprimexsr),2),'b-o','LineWidth',3);
hold on;
yyaxis right;
plot(sigysr,pprimexsr(:,1),'r-*','LineWidth',3);
legend(["entropy of posterior in x";"P'(good) (posterior belief item is good)"],'Location','northeast');
set(gca,'FontWeight', 'bold');
yyaxis right;
ylabel('Probability (item is good)','FontSize',16,'FontWeight','bold','Color','r');
yyaxis left;
ylabel('Entropy','FontSize',16,'FontWeight','bold','Color','b');
xlabel(['\sigma_y^{-2} (certainty in ',dim_labels{dim_to_use},' of this person)'],'FontSize',12,'FontWeight','bold');

title('Figure 6d');

if print_to_file
  print(['figure6d.',output_file_ext],['-d',print_flag]);
end

