%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%  Code for replication of results in the paper:
%%%%  Denotative and Connotative Control of Uncertainty: A Computational Dual Process Model
%%%%  Authors: Jesse Hoey (University of Waterloo),  
%%%%           Neil MacKinnon (University of Guelph),
%%%%           Tobias Schroeder  (Potdsam University of Applied Sciences)
%%%%  Copyright: the authors, 2021
%%%%  For research purposes only.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% This file:  main function to compute posteriors based on equations 15-18 in the paper
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% function for computing posteriors
%% input arguments are 
%% uy,sigy:mean and variance in the prior over y (single Gaussian)
%% pxp: binomial distribution over x
%% xdist: M(x) values for x
%% gamma: gamma value -- can be a distribution with same number of values as x
%% y: range of y to plot over
%% priory_norm: normalize the prior over y with a fixed value (for visualization purposes only) -- the paper used 20.0 for figures 2 and 4
%% if not set, normalize properly
function [priory,pprimey,pprimex] = computePost(uy,sigy,pxp,xdist,gamma,y,priory_norm)
  sigma=sigy*gamma./(sqrt(sigy*sigy+gamma.^2));
  u=sigma.*sigma.*(uy./(sigy*sigy)+xdist./(gamma.^2));

  ym=repmat(y,2,1);
  um=repmat(u',1,size(y,2));

  %% posterior in X - equation 15 in the paper
  pprimex=pxp.*((1./sqrt(2*pi.*(sigy*sigy+gamma.^2))).*exp(-0.5*(xdist-uy).^2./(sigy^2+gamma.^2)));
  %% normalized
  pprimex = pprimex/sum(pprimex);

  %% prior in y 
  priory=(1/sqrt(2*pi*sigy*sigy))*exp(-0.5*(y-uy).^2/(sigy^2));
  %% normalized
  if nargin>6
    priory = priory/priory_norm;
  else
    priory = priory/sum(priory);
  end
  %% posterior in y -- equation 18 in the paper
  pprimey=pprimex.*(1./sqrt(2*pi*(sigma.*sigma)))*exp(-0.5.*(ym-um).^2./(sigma'.^2));
  %% normalized
  pprimey = pprimey/sum(pprimey);



